/* 
    Hi I am Jat Kishan
        in this program we created Single_linked_list with simple view


    some varibles

    NODE        - is data type of struct node
        
        *next       - is represent the next node


    *delnode    - node is use for free node space in memmory
    *head       - node known as first node
    *tail       - tail known as last node
    *node       - is travling node witch use for switching  node  to  next node
    *newnode    - contain new node for adding node
    count       - here count is lenth of linked list
    index       - for store position
    value       - contain insert value and delete value

*/

#include<stdio.h>
#include<stdlib.h>
#include<stdbool.h>

struct node {
    int value;
    struct node *next;
};

typedef struct node NODE;

struct node *head, *tail;
int count = 0;

// int get_entry(int index) {
//     NODE *node = head;
//     int indexCount;
//     indexCount++;
//     while(indexCount < index) {
//         node = node->next;
//         indexCount++;
//     }
//     printf("value is : %d", node->value);
//     return &node;
// }

void addright(int value) {
    NODE *newnode;
    newnode = (NODE*) malloc(sizeof(NODE));

    newnode->value = value;
    newnode->next = NULL;

    if (!head) {
        head = tail = newnode;
    } else {
        tail->next = newnode;
        tail = tail->next;
    }
    count ++;
}

void addleft(int value) {
    NODE *node, *newnode;
    newnode = (NODE *) malloc(sizeof(NODE));

    newnode->value = value;

    if (!head) {
        head = tail = newnode;
    }
    else {
        newnode->next = head;
        head = newnode;
    }
    count ++;
}

void addmid( int index, int value) {
    if (!head) {
        printf("List is empty!     <<<");
        return;
    }
    else if(index == 1) {
        addleft(value);
        return;        
    }

    int indexCount = 0;
    NODE *node, *newnode;
    newnode = (NODE*) malloc(sizeof(NODE));

    newnode->value = value;

    if(index > count) {
        printf("index is out of range!     <<<\n");
    } else {
        node = head;
        indexCount++;

        while(indexCount < index - 1) {
            node = node->next;
            indexCount++;
        }

        newnode->next = node->next;
        node->next = newnode;

        count ++;
    }
}

int delright() {
    NODE *node;
    int value;

    if (!head) {
        printf("List is empty!     <<<");
        return 0;
    }
    
    if (!head->next) {
        value = head->value;
        free(head);
        head = tail = NULL;
    }
    else {
        node = head;

        while(node->next->next) {   //node->next->next != NULL
            node = node->next;
        }

        value = node->next->value;
        free(node->next);
        node->next = NULL;
        tail = node;
    }

    count --;
    return value;
}

int delleft() {
    NODE *node;
    int value;

    if (!head) {
        printf("List is empty!     <<<");
        return 0;
    }
    if (!head->next) {
        value = head->value;
        free(head);
        head = tail = NULL;
    }
    else {
        node = head;
        value = head->value;
        head = head->next;
        free(node);
    }

    count --;
    return value;
}

int delmid(int index) {
    NODE *node, *prev;
    int value, indexCount = 1;

    if (!head) {
        printf("List is empty!     <<<");
        return 0;
    }
    else if (index > count) {
        printf("index is out of range!     <<<\n");
        return 0;
    }
    else if (index == 1) {
        return delleft();
    }
    else if (index == count) {
        return delright();
    }

    node = head;

    while(indexCount < index) {
        prev = node;
        node = node->next;
        indexCount++;
    }

    value = node->value;
    prev->next = node->next;

    free(node);
        
    count --;
    return value;
}

void display() {
    NODE *node;
    if (!head) {
        printf("\n[ Head = Empty ]     <<<");
    } else {
        node = head;

        printf("\n[ Head = %d ]", node->value);

        if (head == tail) { return; }

        node = node->next;

        while(true) {
            if(node == tail) { break; }
            printf(" -> [ %d ]", node->value);
            node = node->next;
        }

        printf(" -> [ Tail = %d ]", node->value);
    }
    
}

int main(){
    int choice, value, index;
    while(true) {
        printf("\nUse Single linked list\n1. Add elem right\n2. Add elem left\n3. Add elem mid\n4. Delete elem right\n5. Delete elem left\n6. Delete elem mid\n7. Display linked list\n0. Exit\n--> ");
        scanf("%d", &choice);

        switch (choice)
        {
        case 1:
            printf("Enter value: ");
            scanf("%d", &value);
            addright(value);
            break;
        case 2:
            printf("Enter value: ");
            scanf("%d", &value);
            addleft(value);
            break;
        case 3:
            printf("Enter Index: ");
            scanf("%d", &index);
            printf("Enter Value: ");
            scanf("%d", &value);
            addmid(index, value);

            break;
        case 4:
            printf("\tdeleted %d\n",delright());
            break;
        case 5:
            printf("\tdeleted %d\n",delleft());
            break;
        case 6:
            printf("Ener Index: ");
            scanf("%d", &index);
            printf("\tdeleted %d\n",delmid(index));
            break;
        case 7:
            display();
            break;
        case 0:
        printf(" ,,.,,\n`/'`'\\`\n|     |\n(~[@-@]\t\tThanks for useing Single linked list data structure\n \\  -/ \n / \\/\\      ,_________\n|  . '\\     || Thank |\n|\\]    |]   ||__You__|\n `--______  .--_| |_\n          ``               \n\n");
            exit(0);
        default:
            printf("Not correct choice!     <<<");
        }   
    }
    return 0;
}
